function ep=effectiveepsilon(P,gr)
%ep=effectiveepsilon(P)
%Calculates effective absorption coefficient ("ep") of radiation that does not need to be monochromatic. 
%The first column of the matrix "P" are wavelengths, 
% the second column is the spectral distribution of radiation (ie. the spectral density of photon flux), 
% the third column is the spectral dependence of the absorption coefficient. 
%If gr=1, a graph of both spectral dependencies is shown. 


%Orderin of the matrix: 
[nic,por]=sort(P(:,1));
for j=1:length(P(:,1)),
 a(j,:)=P(por(j),:); 
end
P=a; 

%Spectral integration: 
d=P(2:end,1)-P(1:(end-1),1);
sp=(P(1:end-1,2)+P(2:end,2))/2;
b2=(P(1:end-1,3)+P(2:end,3))/2; 
ep=sum(sp.*b2.*d)/sum(sp.*d);


%Plot of data: 
if gr==1
 x=(P(1:end-1,1)+P(2:end,1))/2; 
 figure; 
 b2=(P(1:end-1,3)+P(2:end,3))/2; 
 [AX,g1,g2]=plotyy(x,sp/sum(sp.*d),x,b2); 
 osy=axis;
 osy(3)=min(sp/sum(sp.*d));
 axis(osy); 
 set(AX(2),'ylim',[osy(3)*max(b2)/osy(4) max(b2)]);
 grid on; 
 xlabel('Wavelength'); 
 ylabel('Spectrum of light'); 
 set(get(AX(2),'Ylabel'),'String','Cross section of absorption');
end 
